//___________________________________
//                                   \
// Ethernum: Pause Engine. version 1.1
//___________________________________/


/*
 Enable a pause in your game

 Usage:
   EvaluateScript("ethernum.js");
   var Pause=new EthernumEngine(KEY_P, KEY_P, undefined, undefined,
	"'PAUSED, press '+GetKeyString(this.pausekey,false)+' to continue'"
	);
   Pause.SetHookUpdateScript("Movement_Update()");	// calls 'Movement_Update()' before all map layers are rendered
   Pause.SetHookRenderScript("Render_Update()");	// calls 'Render_Update()'   after  all map layers are rendered
   Pause.HookUpdateAndRender();
   Pause.SetAudio(Music);	//make sound also pause
   Pause.SetTimer(Clock);		//make timer clock also pause
   Rethorica.Pause=Pause; //If using Rethorica, link it to the pause.

   Pause.run();	//Activate the pause script.

   Known Bugs: ?

		Functions in this library:

*******************************************************************************

EthernumEngine(pausekey,unpausekey,pausesoundfile,unpausesoundfile,pausetext,pausefont)
	Create a new EthernumEngine object.
	pausekey: Key that should be pressed to pause
	unpausekey: Key that should be pressed to unpause
	pausesoundfile: filename of a sound
	unpausesoundfile: filename of a sound
	example:
		var Pause=new EthernumEngine(KEY_P,KEY_P,'tu-ting.ogg','beep.ogg',"'PAUSED, press P to continue'");

isPaused
	boolean. True if run()

checkPause()
	boolean. True if the pausekey is pressed
	example:
		Pause.checkPause();

checkUnPause()
	boolean. True if the unpausekey is pressed, which you can override with your own.
	example:
		Pause.checkUnPause=function(){
			if(typeof this.oldMouseX == 'undefined') this.oldMouseX = GetMouseX();
			if(typeof this.oldMouseY == 'undefined') this.oldMouseY = GetMouseY();
			if(typeof this.lastMouseCheck == 'undefined') this.lastMouseCheck = GetTime_();

			if(this.lastMouseCheck+200<GetTime_()){
				this.lastMouseCheck=GetTime_();
				this.oldMouseX=GetMouseX();
				this.oldMouseY=GetMouseY();
			}

			var mousehasmoved=( (Math.abs(this.oldMouseX-GetMouseX())>5) || (Math.abs(this.oldMouseY-GetMouseY())>5) );
			this.oldMouseX=GetMouseX();
			this.oldMouseY=GetMouseY();
			return(IsJoystickButtonPressed(0,0)||mousehasmoved||IsKeyPressed(this.unpausekey)||IsKeyPressed(KEY_ESCAPE));
		}

run()
	Activate the pause script.
	example:
		Pause.run();

drawPause(BackgroundImage,Ptxt)
	function to manipulate the pause sequence, which you can override with your own
	example:
		Pause.drawPause=function(mov_ScreenImage,pausetext){
			BackgroundImage.blit(0,0);
		   	Rectangle(0,0,GetScreenWidth(),GetScreenHeight(),CreateColor(0,0,0,128));
		  	this.pausefont.drawText(Math.floor((GetScreenWidth()-Ptxt.length)/2)-80, GetScreenHeight()/2), pausetext);
    			FlipScreen();
		}


SetHookUpdateScript()
	Sets the function that holds all update activities. This is before all map layers are rendered
	example:
		Pause.SetHookUpdateScript("Movement_Update()"); // Add this one as default (type is '_')
		Pause.SetHookUpdateScript("Movement_UpdateBattle()", "battle"); // Add alternative update script fit for battle engine

SetHookRenderScript()
	Sets the function that holds all render activities. This is after all map layers are rendered
	example:
		Pause.SetHookRenderScript("Movement_Render()");
		Pause.SetHookUpdateScript("Movement_RenderBattle()", "battle"); // Add alternative render script fit for battle engine

HookUpdateAndRender()
	Internal functions. Used to start all update and rendering activity.
	example:
		Pause.HookUpdateAndRender(); // hooks the default both 
		Pause.HookUpdateAndRender('battle'); // hooks the alternative update and render 'battle'
		Pause.HookUpdateAndRender('battle', '_'); // hooks the alternative update 'battle' and render default (type is '_')

UnHookUpdateAndRender()
	Internal functions. Used to stop all update and rendering activity.
	example:
		Pause.UnHookUpdateAndRender();

RenderMap()
	Runs Sphere's RenderMap() and then the correct Renderscript. (RenderMap() doesnt execute the renderscript)

SetAudio(AcusthicaObject)
	Enable pause BGM during a pause. This is one way to set it, the other
	is giving the ethernum object as parameter to AcusthicaEngine.
	The passed object can be anything but must implement the function .pause(boolean) and .unpause()
	example:
		var MUSIC=new AcusthicaEngine();
		Pause.SetAudio(MUSIC);
	or:
		var Pause=new EthernumEngine(<parameters>);
		var MUSIC=new AcusthicaEngine(Pause);

SetTimer(timerObject)
	Enable pause gametime clock.
	The passed object can be anything but must implement the function .pause(boolean) and .unpause()
	example:
		var CLOCK=new ClockEngine();
		CLOCK.load(gameslot);
		Pause.SetTimer(CLOCK);

*/
//----------------------------------------------------------------------------//

// Copy the original GetTime() function into a GetTime_() function (both now do the same)
// This is because clockengine.js  can modify the original GetTime() function to stop ticking.
if(typeof GetTime_ == 'undefined')
	GetTime_ = GetTime;


/**
 * Create a new EthernumEngine object.
 * @param {key} pausekey: Key that should be pressed to pause
 * @param {key} unpausekey: Key that should be pressed to unpause
 * @param {sound} pausesoundfile: filename of a sound
 * @param {sound} unpausesoundfile: filename of a sound
 * @param {string} pausetext
 * @param {Font} pausefont, leave undefined if you want the system font.
 * example:
 * 	var Pause=new EthernumEngine(KEY_P,KEY_P,'tu-ting.ogg','beep.ogg',"'PAUSED, press P to continue'");
 * @returns An EthernumEngine Object
 * @constructor
 */
function EthernumEngine(pausekey,unpausekey,pausesoundfile,unpausesoundfile,pausetext,pausefont)
{
	if(this instanceof EthernumEngine == false)
		return new EthernumEngine(pausekey,unpausekey,pausesoundfile,unpausesoundfile,pausetext,pausefont);

	this.pausekey = pausekey||KEY_P;
	this.unpausekey = unpausekey||KEY_P;
	this.pausetext = pausetext||"";
	this.pausefont = pausefont||GetSystemFont();
	this.pausesound = (typeof pausesoundfile=='string'?LoadSound(pausesoundfile,false):pausesoundfile);
	this.unpausesound = (typeof unpausesoundfile=='string'?LoadSound(unpausesoundfile,false):unpausesoundfile);
	this.pausepersonlist = new Array(); // GetPersonList();
	this.isPaused = false;
	this.UpdateScript = {_:""};
	this.RenderScript = {_:""};
	this.type = 'default'; // Default type, no real need to change this.
	this.hooked = ''; // The type currently hooked.
}

//----------------------------------------------------------------------------//

/**
 * Check if the pause key is pressed.
 * @returns True if the pausekey is pressed
 * @type Boolean
 */
EthernumEngine.prototype.checkPause = function() { return (AreKeysLeft()&&IsKeyPressed(this.pausekey)); }

/**
 * Check if the unpause key is pressed.
 * @returns True if the unpausekey is pressed
 * @type Boolean
 */
EthernumEngine.prototype.checkUnPause = function() { return (IsKeyPressed(this.unpausekey)||IsKeyPressed(KEY_ESCAPE)); }

//----------------------------------------------------------------------------//

/**
 * Sets the function that holds all update activities. This is before all map layers are rendered
 * You can add multiple, then swap between them.
 * example:
 * 	Pause.SetHookUpdateScript("Movement_Update()");
 * @param {string} script The script you want to run each update loop. If you add a function, it will be converted to string.
 * @param {string} type The type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to this.type, which you can set.
 * note: Pause.SetHookUpdateScript(Movement_Update); will be slower, if you give it a string it converts it to a very long string.
 */
EthernumEngine.prototype.SetHookUpdateScript = function(script,type){
	if (typeof script == 'function'){
		script = script.toString().replace(/^function .*\{$\n/m, "").replace(/\}\n\s*$/,'').replace(/^\s*/mg, "");
	}
	this.UpdateScript[type||this.type] = script;
}

/**
 * Set a string that will run after all map layers are rendered
 * You can add multiple, then swap between them.
 * example:
 * 	Pause.SetHookUpdateScript("Movement_Update_battle()", 'battle');
 * @param {string} script The script you want to run each render loop. If you add a function, it will be converted to string. (and probably run slower)
 * @param {string} type The type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to this.type, which you can set.
 */
EthernumEngine.prototype.SetHookRenderScript = function(script,type){
	if (typeof script == 'function'){
		script = script.toString().replace(/^function .*\{$\n/m, "").replace(/\}\n\s*$/,'').replace(/^\s*/mg, "");
	}
	this.RenderScript[type||this.type] = script;
}

//----------------------------------------------------------------------------//
/**
 * Activate the pause script. Runs the drawPause, will run until unpaused.
 */
EthernumEngine.prototype.run = function() {
	var Ptxt = eval(this.pausetext);

	var mov_ScreenImage = GrabImage(0, 0, GetScreenWidth(), GetScreenHeight());

	this.UnHookUpdateAndRender();
	if(this.pausesound)
		this.pausesound.play();
	// Cant pause the music when its defined directly in a map. I should define it outside... //TODO: Pause Music
	while(IsKeyPressed(this.unpausekey)){
		while(AreKeysLeft()) GetKey();
	}
	while(!this.checkUnPause()) { 
		this.drawPause(mov_ScreenImage,Ptxt);
	}

	// just in case pause and un-pause are the same key.
	while(IsKeyPressed(this.unpausekey)){
		while(AreKeysLeft()) GetKey();
	}
 
	if(this.pausesound && this.pausesound.isPlaying())
		this.pausesound.stop();   
	if(this.unpausesound)
		this.unpausesound.play();   
	this.HookUpdateAndRender();
}

/**
 * Internal function. Draw a paused screen. Redefine if you need something more fancy.
 * @param {image} mov_ScreenImage Background image to blit
 * @param {string} Ptxt Text to fancyfull display
 */
EthernumEngine.prototype.drawPause = function(mov_ScreenImage,Ptxt) {
	mov_ScreenImage.blitMask(0, 0, CreateColor(255,255,255,128));
	//UpdateMapEnginde();//Uncommenting this makes the pause useless as the rest doesnt pause :)
	//RenderMap(); //Dangerous, we should check that we're in a map, we get a background image to blit anyway...
  	this.pausefont.drawText(((GetScreenWidth()-Ptxt.length)>>1)-80, (GetScreenHeight()>>1)+Math.floor(Math.sin(GetTime_()/13)*4),Ptxt);
    	FlipScreen();
	this.wait = GetTime_() + 100; while(GetTime_()<this.wait){ };
}

//----------------------------------------------------------------------------//

/**
 * Enable all update and rendering activity. Unpause audio and timer. Ready for playing.
 * @param {string} typeUpdate The Update type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to this.type, which you can set.
 * @param {string} typeRender The Render type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to typeUpdate or this.type
 */
EthernumEngine.prototype.HookUpdateAndRender = function(typeUpdate,typeRender) {
	SetUpdateScript(this.UpdateScript[this.hooked = typeUpdate||this.type]);
	SetRenderScript(this.RenderScript[typeRender||typeUpdate||this.type]);
	if(this.isPaused) {
		this.isPaused = false;
		if(this.audio)
			this.audio.unpause();
		if(this.timer)
			this.timer.unpause();
	}
}

/**
 * Because RenderMap() does not execute the Render Update script!
 * @param {string} typeRender The Render type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to typeUpdate or this.type
 */
EthernumEngine.prototype.RenderMap = function(typeRender) {
	RenderMap();
	return eval(this.RenderScript[typeRender||this.type]);
}


/**
 * Swap update and rendering types, for example, when going into the worldmap, you may have a reduced set of keyboard options available.
 * @param {string} typeUpdate The Update type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to this.type, which you can set.
 * @param {string} typeRender The Render type it is, for example: 'minigame', 'cutscene', 'full'. Optional, defaults to typeUpdate or this.type
 * You can actually swap the update and render scripts by empty ones (like UnHookUpdateAndRender, but without pausing time and audio), just use: 
 *   Pause.SwapUpdateAndRender("_", "_");
 */
EthernumEngine.prototype.SwapUpdateAndRender = function(typeUpdate,typeRender) {
	SetUpdateScript(this.UpdateScript[typeUpdate||this.type]);
	SetRenderScript(this.RenderScript[typeRender||this.type]);
}


/**
 * Disable all update and rendering activity. Pause audio and timer. Ready for cutscenes or pause.
 * Use this function directly before going into the inventory menu, for example. (don't forget to hookup again!)
 */
EthernumEngine.prototype.UnHookUpdateAndRender = function() {
	SetUpdateScript("");
	SetRenderScript("");
	if(!this.isPaused){
		this.isPaused=true;
		if(this.audio)
			this.audio.pause();
		if(this.timer)
			this.timer.pause();
	}
}

//----------------------------------------------------------------------------//

/**
 * Enable pause BGM during a pause. This is one way to set it, the other
 * is giving the ethernum object as parameter to AcusthicaEngine.
 * The passed object can be anything but must implement the function .pause() and .unpause()
 * @param {Object} obj Audio Object
 * example:
 * 	var MUSIC=new AcusthicaEngine();
 * 	Pause.SetAudio(MUSIC);
 * or:
 * 	var Pause=new EthernumEngine(<parameters>);
 * 	var MUSIC=new AcusthicaEngine(Pause);
 */
EthernumEngine.prototype.SetAudio = function(obj){ this.audio = obj; }

/**
 * Enable pause gametime clock.
 * The passed object can be anything but must implement the function .pause() and .unpause()
 * @param {Object} obj Timer Object
 * example:
 * 	var CLOCK=new ClockEngine();
 * 	CLOCK.load(gameslot);
 * 	Pause.SetTimer(CLOCK);
 */
EthernumEngine.prototype.SetTimer = function(obj){ this.timer = obj; }

//----------------------------------------------------------------------------//


